/*  GWhere
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwcatalogfileinfo.h"

#include <string.h> /* strcmp */
#include <sys/stat.h> /* stats */


typedef struct catalog_file_info
{
	gchar *title;				/* Catalog name					*/
	gchar *name;				/* Catalog file name			*/
	gchar *full_name;			/* Catalog full path name		*/
	gchar *version;				/* Catalog version				*/
	gchar *program_maker;		/* Catalog maker name			*/
	GList *categories;			/* Categories list				*/
	gchar *description;			/* Catalog description			*/
	gboolean ismodified;		/* If the catalog is modified	*/
} CatalogFileInfo;


struct catalog_file_info * catalog_file_info_new ( void)
{
	struct catalog_file_info *p = NULL;
	struct category *category = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( (p = (struct catalog_file_info*)g_malloc0 ( sizeof ( struct catalog_file_info))) != NULL )
	{
		p->name = NULL;
		p->title = NULL;
		p->full_name = NULL;
		p->version = NULL;
		p->program_maker = NULL;
		p->categories = NULL;
		p->description = NULL;
		p->ismodified = FALSE;
	}

	/* Warning it's a dirty code!! */
	category = category_new ( );
	category_set_name ( category, g_strdup ( _( "none")));
	catalog_file_info_append_category ( p, category);

	return p;
}


gint catalog_file_info_set_title ( struct catalog_file_info *p, gchar *title)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->title != NULL )
		{
			g_free ( p->title);
		}

		p->title = title;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_name ( struct catalog_file_info *p, gchar *name)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			g_free ( p->name);
		}

		p->name = name;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_full_name ( struct catalog_file_info *p, gchar *full_name)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->full_name != NULL )
		{
			g_free ( p->full_name);
		}

		p->full_name = full_name;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_version ( struct catalog_file_info *p, gchar *version)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->version != NULL )
		{
			g_free ( p->version);
		}

		p->version = version;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_program_maker ( struct catalog_file_info *p, gchar *program_maker)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->program_maker != NULL )
		{
			g_free ( p->program_maker);
		}

		p->program_maker = program_maker;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_categories ( struct catalog_file_info *p, GList *categories)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->categories != NULL )
		{
			g_list_foreach ( p->categories, (GFunc)g_free, NULL);
			g_free ( p->categories);
		}

		p->categories = g_list_first ( categories);

		return 0;
	}

	return -1;
}


gint catalog_file_info_append_category ( struct catalog_file_info *p, struct category *category)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( category != NULL )
		{
			p->categories = g_list_append ( p->categories, category);
//			category_set_index ( category, g_list_position ( g_list_first ( p->categories), p->categories));
			category_set_index ( category, g_list_length ( g_list_first ( p->categories)) - 1);

			return 0;
		}
		else
		{
			return -1;
		}
	}

	return -1;
}


gint catalog_file_info_remove_category ( struct catalog_file_info *p, struct category *category)
{
	gint index, i, size;
	GList *categories = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( category != NULL )
		{
			categories = catalog_file_info_get_categories ( p);
			size = g_list_length ( g_list_first ( categories)) - 1;
			index = category_get_index ( category);

			categories = g_list_remove ( categories, category);
			categories = g_list_first ( categories);
			p->categories = g_list_first ( categories);

			categories = g_list_nth ( categories, index);

			for ( i = index; i < size; i++)
			{
				category_set_index ( categories->data, category_get_index ( categories->data) - 1);
				categories = g_list_next ( categories);
			}

			return 0;
		}
		else
		{
			return -1;
		}
	}

	return -1;
}


gint catalog_file_info_set_description ( struct catalog_file_info *p, gchar *description)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			g_free ( p->description);
		}

		p->description = description;

		return 0;
	}

	return -1;
}


gint catalog_file_info_set_ismodified ( struct catalog_file_info *p, gboolean b)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->ismodified = b;

		return 0;
	}

	return -1;
}


gchar * catalog_file_info_get_title ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->title != NULL )
		{
			return p->title;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * catalog_file_info_get_name ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			return p->name;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * catalog_file_info_get_full_name ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->full_name != NULL )
		{
			return p->full_name;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * catalog_file_info_get_version ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->version != NULL )
		{
			return p->version;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * catalog_file_info_get_program_maker ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->program_maker != NULL )
		{
			return p->program_maker;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


GList * catalog_file_info_get_categories ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : categories list isn't null.\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		return p->categories;
	}

#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : categories list is null!!\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	return NULL;
}

struct category * catalog_file_info_get_category ( struct catalog_file_info *p, gchar *category)
{
	gint i = 0, size= 0;
	GList *categories = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	categories = catalog_file_info_get_categories ( p);
	categories = g_list_first ( categories);
	size = g_list_length ( categories);

	for ( i = 0; i < size; i++)
	{
		if ( strcmp ( category, category_get_name ( categories->data)) == 0 )
		{
			return categories->data;
		}

		categories = g_list_next ( categories);
	}

	return catalog_file_info_get_category ( p, "none");
}


struct category * catalog_file_info_get_category_by_index ( struct catalog_file_info *p, guint index)
{
	GList *categories = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	categories = catalog_file_info_get_categories ( p);

	if ( index > g_list_length ( categories) )
	{
		return catalog_file_info_get_category_by_index ( p, 0);
	}

	categories = g_list_nth ( categories, index);

	return categories->data;
}


gchar * catalog_file_info_get_description ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			return p->description;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gulong catalog_file_info_get_size ( struct catalog_file_info *p)
{
	struct stat f_info;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( stat( catalog_file_info_get_full_name ( p), &f_info) != -1 )
		{
			return f_info.st_size;
		}
	}

	return 0;
}


gboolean catalog_file_info_get_ismodified ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->ismodified;
	}

	/* p doesn't exists, it may not be modified.*/
	return FALSE;
}


gint catalog_file_info_category_free ( struct category *category, gpointer data)
{
	gint result = -1;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( category != NULL )
	{
		category_free ( category);

		result = 0;
	}

	return result;
}


gboolean catalog_file_info_free ( struct catalog_file_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( p != NULL )
	{
		catalog_file_info_set_name ( p, NULL);
		catalog_file_info_set_title ( p, NULL);
		catalog_file_info_set_full_name ( p, NULL);
		catalog_file_info_set_version ( p, NULL);
		catalog_file_info_set_program_maker ( p, NULL);

		if ( p->categories != NULL )
		{
			g_list_foreach ( p->categories, (GFunc)catalog_file_info_category_free, NULL);
			g_list_free ( p->categories);
		}

		catalog_file_info_set_description ( p, NULL);

		g_free ( p);

		return TRUE;
	}

	return FALSE;
}
