/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwdirdata.h"

#include <string.h> /* strcmp */


typedef struct dir_data
{
	struct file_info *info;		/* Directory informations (as file informations)			*/
	GList *child;			/* List of files in the directory (this list excludes all sub folders)	*/
} DirData;


DirData * dir_data_new ( void)
{
	DirData *p = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( (p = (DirData*)g_malloc0 ( sizeof ( DirData))) != NULL )
	{
		p->info = NULL;
		p->child = NULL;
	}

	return p;
}


gint dir_data_set_info ( DirData *p, struct file_info *info)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->info != NULL )
		{
			file_info_free ( p->info);
		}

		p->info = info;
	}

	return 0;
}


gint dir_data_set_child ( DirData *p, GList *child)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->child != NULL )
		{
			g_list_foreach ( p->child, (GFunc)file_info_free, NULL);
			g_list_free ( p->child);
		}

		p->child = child;
	}

	return 0;
}


gint dir_data_append_child ( struct dir_data *p, struct file_info *child)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->child = g_list_append ( p->child, child);
	}

	return 0;
}


gint dir_data_remove_child ( struct dir_data *p, struct file_info *child)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		file_info_free ( child);
		p->child = g_list_remove ( p->child, child);
	}

	return 0;
}


struct file_info * dir_data_get_info ( DirData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->info;
	}

	return NULL;
}


GList * dir_data_get_child ( DirData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->child;
	}

	return NULL;
}


GList * dir_data_get_child_named ( struct dir_data *p, gchar *name)
{
	GList *child = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		child = p->child;
		child = g_list_first ( child);

		while ( child != g_list_last ( child) )
		{
			if ( strcmp ( file_info_get_name ( child->data), name) == 0 )
			{
				return child;
			}

			child = g_list_next ( child);
		}

		if ( child != NULL )
		{
			if ( strcmp ( file_info_get_name ( child->data), name) == 0 )
			{
				return child;
			}
		}
	}

	return NULL;
}


int dir_data_get_num_file ( struct dir_data *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return g_list_length ( p->child);
	}

	return 0;
}


gboolean dir_data_free ( DirData *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( p != NULL )
	{
		file_info_free ( p->info);

		if ( p->child != NULL )
		{
			g_list_foreach ( p->child, (GFunc)file_info_free, NULL);
			g_list_free ( p->child);
		}

		g_free ( p);

		return TRUE;
	}

	return FALSE;
}
