/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwmenufilecallback.h"

#include <string.h> /* strcmp strlen */

#include "data/gwdata.h"
#include "res/gwres.h"

#include "gwpropertiesbox.h"
#include "gwstatusbar.h"
#include "gwcapturebox.h"
#include "gwwindowboxmail.h"
#include "gwmsgbox.h"
#include "gwdialogbox.h"
#include "gwmsgbox.h"
#include "gwfileselectionbox.h"
#include "gwnotebookmanagmentcallback.h"
#include "gwnotebookcatalog.h"

#include "../gwcatalogmanager.h"
#include "../gwapplicationmanager.h"
#include "../gwguimanager.h"


gboolean gw_menu_file_new_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gchar *msg = NULL;
struct catalog_file_info *catalog = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "creating new catalog ==> memory status : ");
	g_mem_profile ( );
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );
		catalog = gtk_ctree_node_get_row_data ( tree, root);

		/* Checks if a catalog has been modified */
		if ( catalog_file_info_get_ismodified ( catalog) )
		{
			/* If has been modified, ask to save it before create new catalog */
			if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			} else {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			}
			gw_dialog_box_create ( w, _( "New file"), msg, GTK_SIGNAL_FUNC ( gw_menu_file_new_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_new_save_file_no), NULL, NULL);
			g_free ( msg);
		}
		else
		{
			/* Else ask the new catalog name */
			gw_capture_box_create ( w, _( "New catalog"), _( "Enter catalog name"), "", GTK_SIGNAL_FUNC ( gw_menu_file_new_file_ok));
		}
	}

	return TRUE;
}


gboolean gw_menu_file_open_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gchar *msg = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		/* Checks if a catalog has been modified */
		if ( catalog_file_info_get_ismodified ( gtk_ctree_node_get_row_data ( tree, root)) )
		{
			/* If has been modified, ask to save it before open another catalog */
			if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			} else {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			}
			gw_dialog_box_create ( w, _( "Open file"), msg, GTK_SIGNAL_FUNC ( gw_menu_file_open_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_open_save_file_no), NULL, NULL);
			g_free ( msg);
		}
		else
		{
			/* Else opens file selection box */
			gw_file_selection_box_create ( _( "Open catalog"), NULL, (GtkSignalFunc)gw_menu_file_open_file_ok, (GtkSignalFunc)gw_menu_file_open_file_cancel);
		}
	}

	return TRUE;
}


gboolean gw_menu_file_close_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = gw_gui_manager_main_interface_get_tree ( );
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );
	gchar *tmp_text = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "closing new catalog ==> memory status : ");
	g_mem_profile ( );
#endif

	/* Checks if a catalog has been modified */
	if ( catalog_file_info_get_ismodified ( gtk_ctree_node_get_row_data ( tree, root)) )
	{
		/* If has been modified, ask to save it before close it */
		if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
			tmp_text = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
		} else {
			tmp_text = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
		}
		gw_dialog_box_create ( w, _( "Close file"), tmp_text, GTK_SIGNAL_FUNC ( gw_menu_file_close_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_close_save_file_no), NULL, NULL);
		g_free ( tmp_text);
	}
	else
	{
		/* Else closes it */
		gw_notebook_catalog_ctree_destroy_all ( );
	}

#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "new catalog closed ==> memory status : ");
	g_mem_profile ( );
#endif

	return TRUE;
}


gboolean gw_menu_file_send_mail_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gboolean result = FALSE;
	gchar *msg = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		/* Check if the mail options if configured. */
		if ( gw_application_manager_can_send_mail ( ) )
		{
			tree = gw_gui_manager_main_interface_get_tree ( );
			root = gw_gui_manager_main_interface_get_tree_root ( );

			/* Checks if a catalog has been modified */
			if ( catalog_file_info_get_ismodified ( gtk_ctree_node_get_row_data ( tree, root)) )
			{
				/* If has been modified, ask to save it before send it by mail */
				if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
					msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
				} else {
					msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
				}
				gw_dialog_box_create ( w, _( "Send file by mail"), msg, GTK_SIGNAL_FUNC ( gw_menu_file_send_mail_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_send_mail_save_file_no), NULL, NULL);
				g_free ( msg);
			}
			else
			{

				/* Else send it by mail */
				gw_mail_window_box_create ( w, catalog_file_info_get_full_name ( gtk_ctree_node_get_row_data ( tree, root)));
			}

			result = TRUE;
		}
		else
		{
			gw_msg_box_create ( w, _( "Send file by mail"), _( "Please configure mail options in the settings in order to send mails."));
		}
	}

	return result;
}



gboolean gw_menu_file_send_mail_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	struct catalog_file_info *catalog_info = NULL;
	gboolean result = FALSE;
	GtkWindow * window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL)
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		catalog_info = gtk_ctree_node_get_row_data ( tree, root);

		/* Destroys the dialog box. */
		gtk_widget_destroy ( GTK_WIDGET ( dg));

		/* Checks if it's a new catalog (in this case his full name is "./[catalog_full_name]"). */
		if ( catalog_file_info_get_full_name ( catalog_info)==NULL || strlen ( catalog_file_info_get_full_name ( catalog_info))==0 )
		{
			/* If it's a new catalog, asks a file name. */
			gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( catalog_info), (GtkSignalFunc)gw_menu_file_send_mail_saveas_file_selection_ok, NULL);
		}
		else
		{
			window = gw_gui_manager_main_interface_get_main_window ( );

			/* Else save it directly and send it by mail. */
			gw_menu_file_save_click ( NULL, NULL);

			/* Shows the mail window box. */
			gw_mail_window_box_create ( window, catalog_file_info_get_full_name ( catalog_info));
		}

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_send_mail_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	GtkWindow *window = NULL;
	struct catalog_file_info *catalog_info = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		/* Destroys the dialog box. */
		gtk_widget_destroy ( GTK_WIDGET ( dg));

		/* Gets catalog informations */
		catalog_info = gtk_ctree_node_get_row_data ( tree, root);

		/* Shows the mail window box. */
		gw_mail_window_box_create ( window, catalog_file_info_get_full_name ( catalog_info));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_send_mail_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	GtkWindow *window = NULL;
	struct catalog_file_info *catalog_info = NULL;
	gboolean result = FALSE;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );

		g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8);

		if ( (strlen ( text_utf8) > 0 ) && (strcmp ( text_utf8, "") != 0) )
		{
			/* Updates informations of opened catalog. */
			catalog_info = gw_application_manager_get_current_catalog ( );

			/* Updates informations of opened catalog. */
			switch ( gw_application_manager_save_catalog ( gtk_file_selection_get_filename ( fs)))
			{
				case 0:
							break;

				case GWECATNOMODIFIED:
							break;

				case GWECATNOFILENAME:
							break;

				case GWECATCANNOTSAVE:
							break;

				default:
							break;
			}

			/* Closes the file selection box. */
			gtk_widget_destroy ( GTK_WIDGET ( fs));

			/* Shows the mail window box. */
			gw_mail_window_box_create ( window, catalog_file_info_get_full_name ( catalog_info));
		}

		g_free ( text_utf8);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_properties_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = gw_gui_manager_main_interface_get_tree ( );
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		/* Checks if a catalog is opened */
		if ( root != NULL )
		{
			gw_properties_box_create_catalog ( mi, w, tree, root);

			return TRUE;
		}
		else
		{
			gw_msg_box_create ( w, _( "Catalog properties"), _( "No catalog is opened"));
		}
	}

	return result;
}


gboolean gw_menu_file_save_click ( GtkMenuItem *mi, GtkWindow *w)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	switch ( gw_application_manager_save_catalog ( NULL))
	{
		case 0:			result = TRUE;

					break;

		case GWECATNOMODIFIED:
					break;

		case GWECATNOFILENAME:	//TODO should we set the catalog title as catalog file name by default in the file selection box??
					tree = gw_gui_manager_main_interface_get_tree ( );
					root = gw_gui_manager_main_interface_get_tree_root ( );
					gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), (GtkSignalFunc)gw_menu_file_saveas_file_selection_ok, NULL);

					break;

		case GWECATCANNOTSAVE:
					break;

		default:
					break;
	}

	return result;
}


gboolean gw_menu_file_saveas_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		/* Checks if the catalog has been modified */
		if ( root != NULL )
		{
			if ( catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen ( catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)))>0 ) {
				gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), (GtkSignalFunc)gw_menu_file_saveas_file_selection_ok, NULL);
			} else {
				gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), (GtkSignalFunc)gw_menu_file_saveas_file_selection_ok, NULL);
			}
		}
	}

	return TRUE;
}


gboolean gw_menu_file_exit_click ( GtkMenuItem *mi, GtkWindow *w)
{
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	GtkWindow *window = NULL;
	gchar *tmp_text[2];


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		/* Checks if a catalog has been modified */
		if ( catalog_file_info_get_ismodified ( gtk_ctree_node_get_row_data ( tree, root)) )
		{
			/* If has been modified, ask to save it before exit program */
			tmp_text[0] = g_strconcat ( _( "Quit "), PROJECT_NAME, NULL);
			if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
				tmp_text[1] = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			} else {
				tmp_text[1] = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			}

			gw_dialog_box_create ( window, tmp_text[0], tmp_text[1], GTK_SIGNAL_FUNC ( gw_menu_file_exit_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_exit_save_file_no), NULL, NULL);
			g_free ( tmp_text[0]);
			g_free ( tmp_text[1]);
		}
		else
		{
			/* Else exit program */
			gw_menu_file_exit ( );
		}
	}

	return TRUE;
}


gboolean gw_menu_file_open_file_ok ( GtkObject *ob, GtkFileSelection *fs)
{
	struct catalog_file_info *file_info;
	GtkWindow *window = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL )
	{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : beginning...\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8);

		/* Checkes if a catalog has been selected */
		if ( (strlen ( text_utf8) > 0) && (strcmp ( text_utf8, "") != 0) )
		{
			gtk_widget_hide ( GTK_WIDGET ( fs));
			file_info = gtk_ctree_node_get_row_data ( tree, root);

			if ( file_info != NULL )
			{
				/* If a catalog is opened, don't save it. Destroys the tree and remove the window title. */
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
				g_print ( "*** GW - %s (%d) :: %s() : a catalog is allready opened\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

				gw_notebook_catalog_ctree_destroy_all ( );
			}

			/* Loads the catalog. */
			gw_application_manager_load_catalog ( gtk_file_selection_get_filename ( fs));

			gtk_widget_destroy ( GTK_WIDGET ( fs));
		}

		g_free ( text_utf8);
	}

	return FALSE;
}


gboolean gw_menu_file_open_file_cancel ( GtkObject *ob, GtkFileSelection *fs)
{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL)
	{
		gtk_widget_destroy ( GTK_WIDGET ( fs));

		return TRUE;
	}

	return FALSE;
}


gboolean gw_menu_file_new_file_ok ( GtkWidget *bt, GtkWindow *w)
{
	struct catalog_file_info *file_info = NULL;
	gchar *text_utf8[2];
	gchar *title = NULL;
	GtkWindow *window = gw_gui_manager_main_interface_get_main_window ( );
	GtkCTree *tree = gw_gui_manager_main_interface_get_tree ( );
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	text_utf8[0] = gw_capture_box_get_text ( w);

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : catalog name = %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, text_utf8[0]);
#endif

	if ( (text_utf8[0] != NULL) && (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
	{
		/* Checks if a catalog is allready opened */
		if ( root != NULL )
		{
			/* If is opened, closes it */
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
			g_print ( "*** GW - %s (%d) :: %s() : a catalog is allready opened\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

			gw_notebook_catalog_ctree_destroy_all ( );
		}

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : initializes the catalog data structure\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* Initializes the catalog data structure*/
		file_info = catalog_file_info_new ( );
		catalog_file_info_set_title ( file_info, g_strdup ( text_utf8[0]));
		catalog_file_info_set_program_maker ( file_info, g_strdup ( PROJECT_NAME));
		catalog_file_info_set_ismodified ( file_info, TRUE);

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : writes the new window title\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* Writes the new window title */
		title = g_strconcat ( PROJECT_NAME, " - ", catalog_file_info_get_title ( file_info), NULL);
		g_strdup_to_gtk_text ( title, text_utf8[1]);
		g_free ( title);
		gtk_window_set_title ( window, text_utf8[1]);
		g_free ( text_utf8[1]);

		g_strdup_to_gtk_text ( text_utf8[0], text_utf8[1]);
		root = gtk_ctree_insert_node ( tree, NULL, NULL, &text_utf8[1], 5, PixCatalog, MskCatalog, PixCatalog, MskCatalog, FALSE, TRUE);
		g_free ( text_utf8[1]);

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		if ( root == NULL )
		{
			g_print ( "*** GW - %s (%d) :: %s() : new node is NULL\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
		}
#endif

		gw_gui_manager_main_interface_set_tree_root ( root);
		gtk_ctree_node_set_row_data_full ( tree, root, file_info, (GtkDestroyNotify)catalog_file_info_free);

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : selects tree's root node\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* Selects tree's root node */
		gtk_ctree_select ( tree, root);

#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : refreshes categories list\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* Refreshes categories list */
		gw_notebook_managment_refresh_categories ( window);

		gtk_widget_destroy ( GTK_WIDGET ( w));
	}

	g_free ( text_utf8[0]);

#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "new catalog created ==> memory status : ");
	g_mem_profile ( );
#endif

	return TRUE;
}


gboolean gw_menu_file_new_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	window = gw_gui_manager_main_interface_get_main_window ( );

	gtk_widget_destroy ( GTK_WIDGET ( dg));
	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if is a new catalog (in this case his full name is "./[catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks a file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_new_saveas_file_selection_ok, NULL);
	}
	else
	{
		/* Else save it directly and displays a fill box of new catalog */
		gw_menu_file_save_click ( NULL, NULL);
		gw_capture_box_create ( window, _( "New catalog"), _( "Enter catalog name"), "", GTK_SIGNAL_FUNC ( gw_menu_file_new_file_ok));
	}

	return TRUE;
}


gboolean gw_menu_file_new_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	GtkWindow *window = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{

		gtk_widget_destroy ( GTK_WIDGET ( dg));

		window = gw_gui_manager_main_interface_get_main_window ( );
		gw_capture_box_create ( window, _("New catalog"), _("Enter catalog name"), "", GTK_SIGNAL_FUNC ( gw_menu_file_new_file_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_new_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	GtkWindow *window = NULL;
	gchar *text_utf8[2];
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

	if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
	{
		/* Saves the catalog. */
		g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);
		switch ( gw_application_manager_save_catalog ( text_utf8[1]))
		{
			case 0:
						break;

			case GWECATNOMODIFIED:
						break;

			case GWECATNOFILENAME:
						break;

			case GWECATCANNOTSAVE:
						break;

			default:
						break;
		}

		g_free ( text_utf8[1]);

		/* Close the file selection box and displays a new fill box of new catalog. */
		gtk_widget_destroy ( GTK_WIDGET ( fs));
		window = gw_gui_manager_main_interface_get_main_window ( );
		gw_capture_box_create ( window, _("New catalog"), _("Enter catalog name"), "", GTK_SIGNAL_FUNC ( gw_menu_file_new_file_ok));

		result = TRUE;
	}

	g_free ( text_utf8[0]);

	return result;
}


gboolean gw_menu_file_open_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	gtk_widget_destroy ( GTK_WIDGET ( dg));
	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if it's a new catalog (in this case his full name is ".[/catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_open_saveas_file_selection_ok, NULL);
	}
	else
	{
		/* Else save it directly and displays a file selection box to select the catalog to open. */
		gw_menu_file_save_click ( NULL, NULL);

		gw_file_selection_box_create ( _("Open catalog"), NULL, (GtkSignalFunc)gw_menu_file_open_file_ok, (GtkSignalFunc)gw_menu_file_open_file_cancel);
	}

	return TRUE;
}


gboolean gw_menu_file_open_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		gtk_widget_destroy ( GTK_WIDGET ( dg));
		gw_file_selection_box_create ( _("Open catalog"), NULL, (GtkSignalFunc)gw_menu_file_open_file_ok, (GtkSignalFunc)gw_menu_file_open_file_cancel);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_open_recents_files_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gpointer file_index = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );

	file_index = gw_dialog_box_get_user_data ( dg);
	gtk_widget_destroy ( GTK_WIDGET ( dg));

	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if it's a new catalog (in this case his full name is ".[/catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_open_recents_files_saveas_file_selection_ok, file_index);
	}
	else
	{
		/* Else save it directly and displays a file selection box to select the catalog to open. */
		gw_menu_file_save_click ( NULL, NULL);

		/* Warning use a gint value instead of a gpointer value!! */
		result = gw_application_manager_load_catalog_from_recents_files ( GPOINTER_TO_UINT ( file_index));
	}

	return result;
}


gboolean gw_menu_file_open_recents_files_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	gboolean result = FALSE;
	gpointer file_index = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		file_index = gw_dialog_box_get_user_data ( dg);
		gtk_widget_destroy ( GTK_WIDGET ( dg));
		gw_notebook_catalog_ctree_destroy_all ( );

		/* Warning use a gint value instead of a gpointer value!! */
		result = gw_application_manager_load_catalog_from_recents_files ( GPOINTER_TO_UINT ( file_index));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_open_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	gboolean result = FALSE;
	gchar *text_utf8[2];


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL )
	{
		g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

		if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
		{
			/* Save the catalog. */
			g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);
			switch ( gw_application_manager_save_catalog ( text_utf8[1]))
			{
				case 0:			result = TRUE;

							break;

				case GWECATNOMODIFIED:
							break;

				case GWECATNOFILENAME:
							break;

				case GWECATCANNOTSAVE:
							break;

				default:
							break;
			}

			g_free ( text_utf8[1]);

			/* Closes the file selection box and displays a new fill box of new catalog. */
			gtk_widget_destroy ( GTK_WIDGET ( fs));
			gw_file_selection_box_create ( _( "Open catalog"), NULL, (GtkSignalFunc)gw_menu_file_open_file_ok, (GtkSignalFunc)gw_menu_file_open_file_cancel);
		}

		g_free ( text_utf8[0]);
	}

	return result;
}


gboolean gw_menu_file_open_recents_files_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	gboolean result = FALSE;
	gchar *text_utf8[2];
	gpointer file_index = NULL;
	gchar *catalog_path_name = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL )
	{
		g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

		/* Gets the real file name in the recents opened catalogs list, because after saving the current
		   opened catalog, the wanted catalog in the recents list (may) will not have the same index. */
		file_index = gw_file_selection_box_get_user_data ( GTK_WINDOW ( fs));

		/* Warning use a gint value instead of a gpointer value!! */
		catalog_path_name = gw_application_manager_get_catalog_path_name_from_recents_files ( GPOINTER_TO_UINT ( file_index));

		if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
		{
			/* Save the catalog. */
			g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);
			switch ( gw_application_manager_save_catalog ( text_utf8[1]))
			{
				case 0:			result = TRUE;

							break;

				case GWECATNOMODIFIED:
							break;

				case GWECATNOFILENAME:
							break;

				case GWECATCANNOTSAVE:
							break;

				default:
							break;
			}

			g_free ( text_utf8[1]);

			/* Closes the file selection box and displays a new fill box of new catalog. */
			gtk_widget_destroy ( GTK_WIDGET ( fs));

			result = gw_application_manager_load_catalog ( catalog_path_name);
		}

		g_free ( text_utf8[0]);

		if ( catalog_path_name != NULL )
		{
			g_free ( catalog_path_name);
		}
	}

	return result;
}


gboolean gw_menu_file_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	gtk_widget_destroy ( GTK_WIDGET ( dg));
	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if it's a new catalog (in this case his full name is "./[catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks un file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_saveas_file_selection_ok, NULL);
	}
	else
	{
		/* Else save it directly. */
		gw_menu_file_save_click ( NULL, NULL);
	}

	result = TRUE;

	return result;
}


gboolean gw_menu_file_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		gtk_widget_destroy ( GTK_WIDGET ( dg));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	gboolean result = FALSE;
	gchar *text_utf8[2];
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

	if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
	{
		/* Save the opened catalog. */
		g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);
		switch ( gw_application_manager_save_catalog ( text_utf8[1]))
		{
			case 0:			result = TRUE;

						break;

			case GWECATNOMODIFIED:
						break;

			case GWECATNOFILENAME:	tree = gw_gui_manager_main_interface_get_tree ( );
						root = gw_gui_manager_main_interface_get_tree_root ( );
						gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), (GtkSignalFunc)gw_menu_file_saveas_file_selection_ok, NULL);

						break;

			case GWECATCANNOTSAVE:
						break;

			default:
						break;
		}

		g_free ( text_utf8[1]);

		/* Closes the file selection box. */
		gtk_widget_destroy ( GTK_WIDGET ( fs));
	}

	g_free ( text_utf8[0]);

	return result;
}


gboolean gw_menu_file_close_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	gtk_widget_destroy ( GTK_WIDGET ( dg));
	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if it's a new catalog (in this case his full name is "./[catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks a file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_close_saveas_file_selection_ok, NULL);
	}
	else
	{
		/* Else save it directly and close it. */
		gw_menu_file_save_click ( NULL, NULL);

		gw_notebook_catalog_ctree_destroy_all ( );
	}

	result = TRUE;

	return result;
}


gboolean gw_menu_file_close_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		gw_notebook_catalog_ctree_destroy_all ( );
		gtk_widget_destroy ( GTK_WIDGET ( dg));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_close_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	gboolean result = FALSE;
	struct catalog_file_info *catalog_info = NULL;
	gchar *text_utf8[2];


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

	if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
	{
		/* Updates informations of opened catalog. */
		catalog_info = gw_application_manager_get_current_catalog ( );

		if ( catalog_info != NULL )
		{
			g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);

			switch ( gw_application_manager_save_catalog ( text_utf8[1]) )
			{
				case 0:			result = TRUE;

							break;

				case GWECATNOMODIFIED:
							break;

				case GWECATNOFILENAME:
							break;

				case GWECATCANNOTSAVE:
							break;

				default:
							break;
			}

			g_free ( text_utf8[1]);
		}

		/* Closes the file selection box and closes the catalog. */
		gtk_widget_destroy ( GTK_WIDGET ( fs));
		gw_notebook_catalog_ctree_destroy_all ( );
	}

	g_free ( text_utf8[0]);

	return result;
}


gboolean gw_menu_file_exit_save_file_ok ( GtkWidget *bt, GtkWindow *dg)
{
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	tree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	gtk_widget_destroy ( GTK_WIDGET ( dg));
	file_info = gtk_ctree_node_get_row_data ( tree, root);

	/* Checks if it's a new catalog (in this case his full name is "./[catalog_full_name]"). */
	if ( catalog_file_info_get_full_name ( file_info)==NULL || strlen ( catalog_file_info_get_full_name ( file_info))==0 )
	{
		/* If it's a new catalog, asks a file name. */
		gw_file_selection_box_create ( _( "Save as catalog"), catalog_file_info_get_title ( file_info), (GtkSignalFunc)gw_menu_file_exit_saveas_file_selection_ok, NULL);
	}
	else
	{
		/* Else save the catalog directly and exit program. */
		gw_menu_file_save_click ( NULL, NULL);
		gw_menu_file_exit ( );
	}

	result = TRUE;

	return result;
}


gboolean gw_menu_file_exit_save_file_no ( GtkWidget *bt, GtkWindow *dg)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( dg != NULL )
	{
		gtk_widget_destroy ( GTK_WIDGET ( dg));
		gw_menu_file_exit ( );

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_file_exit_saveas_file_selection_ok ( GtkWidget *bt, GtkFileSelection *fs)
{
	gboolean result = FALSE;
	gchar *text_utf8[2];


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( fs != NULL )
	{
		g_strdup_from_gtk_text ( gtk_entry_get_text ( GTK_ENTRY ( GTK_FILE_SELECTION ( fs)->selection_entry)), text_utf8[0]);

		if ( (strlen ( text_utf8[0]) > 0) && (strcmp ( text_utf8[0], "") != 0) )
		{
			/* Saves the catalog. */
			g_strdup_from_gtk_text ( gtk_file_selection_get_filename ( fs), text_utf8[1]);
			switch ( gw_application_manager_save_catalog ( text_utf8[1]) )
			{
				case 0:			result = TRUE;
							break;

				case GWECATNOMODIFIED:
							break;

				case GWECATNOFILENAME:
							break;

				case GWECATCANNOTSAVE:
							break;

				default:
							break;
			}

			g_free ( text_utf8[1]);

			/* Exits the program. */
			gtk_widget_destroy ( GTK_WIDGET ( fs));
			gw_menu_file_exit ( );

			result = TRUE;
		}

		g_free ( text_utf8[0]);
	}

	return result;
}


void gw_menu_file_exit ( void)
{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	/* Exit main program */
	gw_notebook_catalog_ctree_destroy_all ( );
	gw_application_manager_exit ( );
	gtk_main_quit ( );
}


gboolean gw_menu_file_recents_files_item_click ( GtkMenuItem *m, gpointer data)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkCTreeNode *root = NULL;
	gchar *msg = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( m != NULL )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );
		root = gw_gui_manager_main_interface_get_tree_root ( );

		/* Checks if a catalog has been modified */
		if ( catalog_file_info_get_ismodified ( gtk_ctree_node_get_row_data ( tree, root)) )
		{
			/* If has been modified, ask to save it before open another catalog */
			if ( catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root))!=NULL && strlen(catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)))>0) {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			} else {
				msg = g_strconcat ( _( "Would you want save catalog :\n\n"), catalog_file_info_get_name ( gtk_ctree_node_get_row_data ( tree, root)), "\n", NULL);
			}
			gw_dialog_box_create ( window, _( "Open file"), msg, GTK_SIGNAL_FUNC ( gw_menu_file_open_recents_files_save_file_ok), GTK_SIGNAL_FUNC ( gw_menu_file_open_recents_files_save_file_no), NULL, data);
			g_free ( msg);
		}
		else
		{
			/* Warning use a gint value instead of a gpointer value!! */
			result = gw_application_manager_load_catalog_from_recents_files ( GPOINTER_TO_UINT ( data));
		}
	}

	return result;
}
